/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.features.feature.redstonefeatures;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.regions_unexplored.block.RegionsUnexploredBlocks;
import net.regions_unexplored.world.level.block.PointedRedstoneBlock;

public class PointedRedstoneUtils {
    protected static double getRedstoneHeight(double v, double v1, double v2, double v3) {
        if (v < v3) {
            v = v3;
        }
        double d0 = 0.384;
        double d1 = v / v1 * 0.384;
        double d2 = 0.75 * Math.pow(d1, 1.3333333333333333);
        double d3 = Math.pow(d1, 0.6666666666666666);
        double d4 = 0.3333333333333333 * Math.log(d1);
        double d5 = v2 * (d2 - d3 - d4);
        d5 = Math.max(d5, 0.0);
        return d5 / 0.384 * v1;
    }

    protected static boolean isCircleMostlyEmbeddedInStone(WorldGenLevel level, BlockPos pos, int i1) {
        if (PointedRedstoneUtils.isEmptyOrWaterOrLava((LevelAccessor)level, pos)) {
            return false;
        }
        float f = 6.0f;
        float f1 = 6.0f / (float)i1;
        for (float f2 = 0.0f; f2 < (float)Math.PI * 2; f2 += f1) {
            int j;
            int i = (int)(Mth.m_14089_((float)f2) * (float)i1);
            if (!PointedRedstoneUtils.isEmptyOrWaterOrLava((LevelAccessor)level, pos.m_7918_(i, 0, j = (int)(Mth.m_14031_((float)f2) * (float)i1)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isEmptyOrWater(LevelAccessor level, BlockPos pos) {
        return level.m_7433_(pos, PointedRedstoneUtils::isEmptyOrWater);
    }

    protected static boolean isEmptyOrWaterOrLava(LevelAccessor level, BlockPos pos) {
        return level.m_7433_(pos, PointedRedstoneUtils::isEmptyOrWaterOrLava);
    }

    protected static void buildBaseToTipColumn(Direction direction, int i1, boolean bool, Consumer<BlockState> consumer) {
        if (i1 >= 3) {
            consumer.accept(PointedRedstoneUtils.createPointedRedstone(direction, DripstoneThickness.BASE));
            for (int i = 0; i < i1 - 3; ++i) {
                consumer.accept(PointedRedstoneUtils.createPointedRedstone(direction, DripstoneThickness.MIDDLE));
            }
        }
        if (i1 >= 2) {
            consumer.accept(PointedRedstoneUtils.createPointedRedstone(direction, DripstoneThickness.FRUSTUM));
        }
        if (i1 >= 1) {
            consumer.accept(PointedRedstoneUtils.createPointedRedstone(direction, bool ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    protected static void growPointedRedstone(LevelAccessor level, BlockPos pos, Direction direction, int i, boolean bool) {
        if (PointedRedstoneUtils.isRedstoneBase(level.m_8055_(pos.m_121945_(direction.m_122424_())))) {
            BlockPos.MutableBlockPos pos1 = pos.m_122032_();
            PointedRedstoneUtils.buildBaseToTipColumn(direction, i, bool, p_190846_ -> {
                if (p_190846_.m_60713_((Block)RegionsUnexploredBlocks.POINTED_REDSTONE.get())) {
                    p_190846_ = (BlockState)p_190846_.m_61124_((Property)PointedRedstoneBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_46801_((BlockPos)pos1)));
                }
                level.m_7731_((BlockPos)pos1, p_190846_, 2);
                pos1.m_122173_(direction);
            });
        }
    }

    protected static boolean placeRedstoneBlockIfPossible(LevelAccessor level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        if (blockstate.m_204336_(BlockTags.f_144273_)) {
            level.m_7731_(pos, ((Block)RegionsUnexploredBlocks.RAW_REDSTONE_BLOCK.get()).m_49966_(), 2);
            return true;
        }
        return false;
    }

    private static BlockState createPointedRedstone(Direction direction, DripstoneThickness thickness) {
        return (BlockState)((BlockState)((Block)RegionsUnexploredBlocks.POINTED_REDSTONE.get()).m_49966_().m_61124_((Property)PointedRedstoneBlock.TIP_DIRECTION, (Comparable)direction)).m_61124_(PointedRedstoneBlock.THICKNESS, (Comparable)thickness);
    }

    public static boolean isRedstoneBaseOrLava(BlockState state) {
        return PointedRedstoneUtils.isRedstoneBase(state) || state.m_60713_(Blocks.f_49991_);
    }

    public static boolean isRedstoneBase(BlockState state) {
        return state.m_60713_((Block)RegionsUnexploredBlocks.RAW_REDSTONE_BLOCK.get()) || state.m_204336_(BlockTags.f_144273_);
    }

    public static boolean isEmptyOrWater(BlockState state) {
        return state.m_60795_() || state.m_60713_(Blocks.f_49990_);
    }

    public static boolean isNeitherEmptyNorWater(BlockState state) {
        return !state.m_60795_() && !state.m_60713_(Blocks.f_49990_);
    }

    public static boolean isEmptyOrWaterOrLava(BlockState state) {
        return state.m_60795_() || state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_49991_);
    }
}

